%{
Copyright (c) 2011, MIT.
Developed with the sponsorship of the Defense Advanced Research Projects
Agency (DARPA).

Permission is hereby granted, free of charge, to any person obtaining a copy
of this data, including any software or models in source or binary form, as
well as any drawings, specifications, and documentation (collectively "the
Data"), to deal in the Data without restriction, including without
limitation the rights to use, copy, modify, merge, publish, distribute,
sublicense, and/or sell copies of the Data, and to permit persons to whom
the Data is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Data.

THE DATA IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS, SPONSORS, DEVELOPERS, CONTRIBUTORS, OR COPYRIGHT HOLDERS BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE DATA OR
THE USE OR OTHER DEALINGS IN THE DATA.
%}

% Matt Fitzgerald
% maximize utility (w/ threshold) strategy file     (First attempt on aggregated rule path cell arrays)

function [endStates rulesExecuted transCost] = STRATcollapsed_maxEff(MAU,rulePaths,costPaths,cost_thresh,time_thresh,fuzzyParetoNumbers)

numDesigns = size(MAU,1);
numEpochs = size(MAU,2);

endStates = zeros(numDesigns,numEpochs);
rulesExecuted = cell(numDesigns,numEpochs);
transCost = cell(numDesigns,numEpochs);

% set NaN MAUs to -1 (failure)
MAU(isnan(MAU)) = -1;

for d = 1:numDesigns
    disp(['Calculating Maximize Efficiency strategy results for design: ' num2str(d)])
    for e = 1:numEpochs

        
        % find available designs (nonempty cols of costPaths)
        available = [];
        for d2 = 1:numDesigns
            if ~isempty(costPaths{d,d2})
                available = [available d2];
            end
        end
        
    % find avaiable design with best Pareto Eff
        availableEff = fuzzyParetoNumbers(available,e);
        [sortedEff indices] = sort(availableEff,'descend'); % sorts best = last
        sortedAvailable = available(indices);
        
        % designate as unsolved and loop until solved
        unsolved = 1;
        while unsolved
            if isempty(sortedAvailable)
                break
            end
            currTarget = sortedAvailable(end);
            currTargetEff = sortedEff(end);
            % break out if the eff being considered is worse than existing eff
            if currTargetEff >= fuzzyParetoNumbers(d,e)
                break
            end
            
            pathOptions = costPaths{d,currTarget};
            [~, idx] = sort(pathOptions(:,1));
            pathOptions = pathOptions(idx,:);
            for i = 1:size(pathOptions,1)
                if pathOptions(i,1) < cost_thresh && pathOptions(i,2) < time_thresh
                    endStates(d,e) = currTarget;
                    rulesExecuted{d,e} = rulePaths{d,currTarget}{idx(i),:};
                    transCost{d,e} = pathOptions(i,:);
                    unsolved = 0;
                    break
                end
            end
            sortedAvailable(end) = [];
        end
        % reports nothing for this (d,e) if previous loop does not find a solution
        % this is fine if the design is feasible, but we should note
        % failure (endState = NaN) if it is not
        if endStates(d,e) == 0 && MAU(d,e) == -1
            endStates(d,e) = NaN;
        end
    end
end


end